import { Music, Mail, Phone, MapPin, Instagram, Youtube, Twitter } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-sound">
      <div className="container">
        <div className="footer-content-sound">
          <div className="footer-section-sound">
            <div className="footer-logo-sound">
              <div className="footer-logo-icon">
                <Music size={24} strokeWidth={2.5} />
              </div>
              <h2 className="footer-logo-text-sound">SoundRent</h2>
            </div>
            <p className="footer-description-sound">
              Профессиональная аренда музыкального оборудования для концертов, студий и мероприятий. 
              Широкий выбор инструментов и техники премиум-класса.
            </p>
            <div className="footer-social-sound">
              <a href="#" className="social-link-sound">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-sound">
                <Youtube size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-sound">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section-sound">
            <h3 className="footer-title-sound">Навигация</h3>
            <ul className="footer-links-sound">
              <li><a href="/">Мои аренды</a></li>
              <li><a href="/rent">Арендовать</a></li>
              <li><a href="#">Каталог</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section-sound">
            <h3 className="footer-title-sound">Контакты</h3>
            <ul className="footer-links-sound">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@soundrent.ru">info@soundrent.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Музыкальная, 8</span>
              </li>
            </ul>
          </div>
          <div className="footer-section-sound">
            <h3 className="footer-title-sound">Режим работы</h3>
            <ul className="footer-links-sound">
              <li><span>Пн-Вс: 10:00 - 22:00</span></li>
              <li><span>Доставка: 24/7</span></li>
              <li><span>Поддержка: круглосуточно</span></li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-sound">
          <p>&copy; 2025 SoundRent. Звук на новый уровень.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

